#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <StaticConstants.au3>
#include <..\UserInput.au3>

HotKeySet('{ESC}', '_Quit')

Global $aLetters = StringSplit('abcdefghijklmnopqrstuvwxyz', '')
Global $iChar_Counter = 1 ;Letters counter

;Creating GUI with letters
$hGUI = GUICreate('ABCDEFG...', 280, 200, -1, -1, $WS_POPUP)
GUISetBkColor(0x804000)

GUICtrlCreateLabel( _
	'- Press any key to switch the letter' & @CRLF & _
	'- To exit press <ESC>', 0, 10, 280, 40, $SS_CENTER)

GUICtrlSetFont(-1, 8.5, 400, 0, 'Georgia')
GUICtrlSetColor(-1, 0xFFFFFF)

$nChars_Label = GUICtrlCreateLabel(StringUpper($aLetters[$iChar_Counter]), 0, 40, 280, 200, $SS_CENTER)
GUICtrlSetFont(-1, 76, 800, 0, 'Georgia')
GUICtrlSetColor(-1, 0xFF8000)

GUISetState()

While 1
	$aRead = _UserInput_Read('[:ALLNUM:]|[:ALPHA:]|[:ALLFUNC:]|[:ARROW:]|[:SPECIAL:]', 1)
	
	If $aRead[0] Then
		$iChar_Counter += 1
		
		If $iChar_Counter > $aLetters[0] Then
			$iChar_Counter = 1 ;If the counter reached last letter, start from the begining
		EndIf
		
		GUICtrlSetData($nChars_Label, StringUpper($aLetters[$iChar_Counter]))
	EndIf
	
	Sleep(10)
WEnd

Func _Quit()
	Exit
EndFunc
